package fr.asip.cps3.exemple.vues.ecrans.saisie;

import java.awt.GridBagLayout;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.border.EmptyBorder;

import fr.asip.cps3.exemple.vues.FenetrePrincipale;
import fr.asip.cps3.exemple.vues.composants.GridBagHelper;
import fr.asip.cps3.exemple.vues.ecrans.EcranUtil;

/**
 * Classe permettant de modliser l'cran de saisie de 3 PIN
 */
public class Saisie3PIN extends Saisie2PIN {

	/**
	 * Libell PIN 3
	 */
	protected JLabel libellePIN3;
	
	/**
	 * Texte PIN 3
	 */
	protected JPasswordField textePIN3;
	
	/**
	 * Constructeur  2 arguments
	 * @param fenetre La fentre qui doit contenir l'cran de saisie
	 * @param typeEcran Type d'cran
	 */
	public Saisie3PIN(FenetrePrincipale fenetre, int typeEcran) {
		this(fenetre, typeEcran, "Entrez le code PUK :", "Entrez le code PIN :", "R-entrez le code PIN :");
	}

	/**
	 * Constructeur  5 arguments
	 * @param fenetre La fentre qui doit contenir l'cran de saisie
	 * @param typeEcran Type d'cran
	 * @param libelle1 Libell du champ PIN
	 * @param libelle2 Libell du champ PIN2
	 * @param libelle3 Libell du champ PIN3
	 */
	public Saisie3PIN(FenetrePrincipale fenetre, int typeEcran, String libelle1, String libelle2, String libelle3) {

		super(fenetre,typeEcran);
		libellePIN = new JLabel(libelle1);
		libellePIN2 = new JLabel(libelle2);
		libellePIN3 = new JLabel(libelle3);
		textePIN3 = new JPasswordField(32);
    	
	}
	
	/**
     * Renvoie le troisime code PIN
     * @return Troisime code PIN
     */
	public char[] getPIN3() {
		if(textePIN3 != null)
			return textePIN3.getPassword();
		return null;
	}	
	
	/**
	 * Affiche les champs d'entre
	 */
    public void affiche() {

    	JFrame fenetre = this.fenetre.getFenetre();
    	
    	if(fenetre != null && fenetre.getContentPane() != null) {
    	
	    	EcranUtil.supprimeTousLesComposants(((JPanel)fenetre.getContentPane()));
	    	
	        // Cration du layout
	    	((JPanel)fenetre.getContentPane()).setBorder(new EmptyBorder(0, 0, 0, 0));
	        GridBagLayout layout = new GridBagLayout();
	        ((JPanel)fenetre.getContentPane()).setLayout(layout);
	        
	        // Ajout des composants
	        GridBagHelper g = new GridBagHelper(fenetre.getContentPane());
	        // Ligne 0
	        g.ajoute(libellePIN, EcranUtil.styleLibelleSaisie, 0, 0, 1, 1);
	        g.ajoute(textePIN, EcranUtil.styleChampTexteSaisie, 0, 1, 1, 1);
	        // Ligne 1
	        g.ajoute(libellePIN2, EcranUtil.styleLibelleSaisie, 1, 0, 1, 1);
	        g.ajoute(textePIN2, EcranUtil.styleChampTexteSaisie, 1, 1, 1, 1);
	        // Ligne 2
	        g.ajoute(libellePIN3, EcranUtil.styleLibelleSaisie, 2, 0, 1, 1);
	        g.ajoute(textePIN3, EcranUtil.styleChampTexteSaisie, 2, 1, 1, 1);
	        // Ligne 3	        
	        g.ajoute(soumettre, EcranUtil.styleBoutonSoumettre, 3, 0, 1, 2);
	        // Ligne 4
	        g.ajoute(barreStatut, EcranUtil.styleBarreStatut, 4, 0, 1, 2);
	        
    	}
    }
}
